<?php

namespace App\Services;

use Illuminate\Support\Facades\Log;

class VideoDetailsService
{
    public function getVideoDetails(string $videoUrl)
    {
        $command = "C:\ProgramData\chocolatey\bin\yt-dlp.exe --cookies cookies.txt -j \"{$videoUrl}\"";
        exec($command, $output, $return_var);

        if ($return_var === 0) {
            $videoData = json_decode(implode("\n", $output), true);

            if (!is_array($videoData)) {
                Log::error('Invalid JSON response.', ['command' => $command, 'output' => $output]);
                return ['error' => 'Invalid video data.'];
            }

            $videoDetails = [
                'title' => $videoData['title'] ?? 'Unknown Title',
                'description' => $videoData['description'] ?? 'No description available.',
                'thumbnail' => $videoData['thumbnail'] ?? null,
                'formats' => []
            ];

            // Filter and add formats with valid resolution and exclude 'Unknown resolution'
            if (!empty($videoData['formats'])) {
                foreach ($videoData['formats'] as $format) {
                    if (strpos($format['url'], '.m3u8') !== false) {
                        // Skip .m3u8 formats with unknown resolution
                        if (isset($format['resolution']) && $format['resolution'] !== 'Unknown resolution') {
                            $videoDetails['formats'][] = [
                                'resolution' => $format['resolution'] ?? 'Unknown resolution',
                                'url' => $format['url']
                            ];
                        }
                    }
                }
            }

            // Return only the clean video details with valid resolutions
            return $videoDetails;
        } else {
            Log::error('Error executing yt-dlp command.', ['command' => $command, 'output' => $output]);
            return ['error' => 'Error fetching video details.'];
        }
    }
}
