<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\VideoDetailsService;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Process\Exception\ProcessFailedException;
use Symfony\Component\Process\Process;

class VideoController extends Controller
{
    protected $videoDetailsService;

    // Inject the VideoDetailsService into the controller
    public function __construct(VideoDetailsService $videoDetailsService)
    {
        $this->videoDetailsService = $videoDetailsService;
    }
    public function getVideoDetails(Request $request)
    {
        // Validate the video URL
        $request->validate([
            'video_url' => 'required|url',
        ]);

        $videoUrl = $request->input('video_url');

        // Get the video details from the service
        $videoDetails = $this->videoDetailsService->getVideoDetails($videoUrl);

        // Return the result as a JSON response
        return response()->json($videoDetails);
    }

}
