<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Symfony\Component\Process\Process;
use Symfony\Component\Process\Exception\ProcessFailedException;

class NewVedieoController extends Controller
{
    public function getVideo(Request $request)
    {
        // Get the video URL from the request
        $videoUrl = $request->input('video_url');

        // Path to the yt-dlp executable (make sure it's correct)
        $ytDlpPath = 'C:\\ProgramData\\chocolatey\\bin\\yt-dlp.exe'; // Update with actual path

        // Ensure the directory for temporary files exists and is writable
        $tempDirectory = 'C:/temp/directory';

        $tempDirectory = storage_path('temp'); // Use Laravel's storage directory
        if (!is_dir($tempDirectory)) {
            mkdir($tempDirectory, 0755, true);
        }

        // Command to extract video metadata: format, duration, resolution
        $command = [
            $ytDlpPath,
            '--get-format',
            '--get-duration',
            '--get-resolution',
            '--temp-dir',
            $tempDirectory, // Specify temp directory
            '--output',
            "$tempDirectory/%(title)s.%(ext)s", // Specify output directory for temporary files
            $videoUrl
        ];

        // Run the process (yt-dlp command) and capture the output
        $process = new Process($command);
        $process->run();

        // Check if the command was successful
        if (!$process->isSuccessful()) {
            // Capture error output
            $errorOutput = $process->getErrorOutput();
            return response()->json([
                'error' => 'yt-dlp command failed',
                'details' => $errorOutput,
            ], 500);
        }

        // Capture the output of the command (metadata)
        $output = $process->getOutput();

        // Return the metadata as a JSON response
        return response()->json([
            'output' => $output,
        ]);
    }
}
